module marking

// This example show how marks can be given by people logged in
// The marks are intended for user 0 who can show them
// (c) mjp 2007/2008

import StdEnv, StdiTasks, iDataTrivial
import iTaskUtil

derive gForm  Mark, [] 
derive gUpd   Mark, Maybe, []
derive gParse Mark
derive gPrint Mark, Maybe
derive gerda  Mark
derive read   Mark
derive write  Mark

:: Mark = {userName :: String, loginId :: Int, mark :: Int, comment :: String}

Start world = workFlowTask [TraceOff,TraceOn] loginRitual dowork world
where
	loginRitual			= loginProcedure welcome admin

	dowork i accounts	= (accounts.login.loginName, marking i accounts)

	welcome 
	= 	[ Txt "This is an application where all users can give a marking or comment to some event they watch together.",Br,Br
		, Txt "If you are administrated, simply login.",Br
		, Txt "If not, you can create a login.",Br,Br,Br]
		?>> OK
	
	admin v = return_V Void

marking i account 	=	[Txt ("Welcome user " <+++ name),Br,Br] !>> respond i name
where
	name = account.login.loginName

	respond uniqueId name
	=				spawnWorkflow uniqueId True ("Give Mark",    foreverTask (giveMark    uniqueId name))
		#>>			spawnWorkflow uniqueId True ("Give Comment", foreverTask (giveComment uniqueId name))
		#>>			foreverTask show 							


show
=  					readMarksDB
	=>>	\marks -> 	[ Txt "Here are the scores given by the users:", Br, Br
					, STable [Tbl_Border 1]	[[Txt (toString (number i marks)) \\ i <- [0..10]]
							   				,[B [] (toString i) 			  \\ i <- [0..10]]
							   				]
					, Br, Br 
					, Hr []
					, Marquee [] (foldl (+++) "" [m.userName +++ " : " +++ m.comment +++ " +++ "  \\ m <- marks  ])
					, Hr []
					] ?>> Confirm "Refresh"
where	
	number i marks = length [n\\n <- marks | n.mark == i]


giveMark uniqueId name 
= 							readMyMarksDB uniqueId
	=>> \(mark,comment) ->	[ Txt ("Previous mark given:" <+++ if (mark == -1) "No mark given" (toString mark)), Br, Br
							, Txt "Give your new mark (0 = lowest, 10 = highest)", Br, Br] 
							?>> chooseTask [] [(toString i,return_V i) \\ i <- [0..2]] -||-
								chooseTask [] [(toString i,return_V i) \\ i <- [3..5]] -||-
								chooseTask [] [(toString i,return_V i) \\ i <- [6..8]] -||-
								chooseTask [] [(toString i,return_V i) \\ i <- [9..10]]
	=>> \mark -> 			readMyMarksDB uniqueId
	=>> \(_,comment) ->		writeMarksDB {userName = name, loginId = uniqueId, mark = mark, comment = comment}
	#>>						[Txt ("Your mark " <+++ mark <+++ " has been stored!"),Br,Br]
							?>> OK

giveComment uniqueId name 
= 							readMyMarksDB uniqueId
	=>> \(mark,comment) ->	[ Txt "Previous comment given:", Br, Br
							, Txt (if (comment == "" ) "None" comment), Br, Br
							, Txt "Submit a new comment:", Br, Br] 
							?>> editTask "OK" textBox <<@ Submit
	=>> \(TextArea _ _ comment) -> readMyMarksDB uniqueId
	=>> \(mark,_) ->		
							writeMarksDB {userName = name, loginId = uniqueId, mark = mark, comment = comment}
	#>>						[ Txt "Your comment:", Br, Br
							, Txt comment, Br, Br
							, Txt "has been stored!",Br,Br]
							?>> OK
where
	textBox :: TextArea
	textBox = createDefault

Confirm name =  buttonTask name (return_V Void)

OK = Confirm "OK" 

// database specialized

marksId :: DBid [Mark]
marksId	= mkDBid "marks" TxtFile

readMarksDB :: Task [Mark]
readMarksDB = readDB marksId

readMyMarksDB :: Int -> Task (Int,String)
readMyMarksDB id
=					readMarksDB
	=>>	\marks ->	return_V 	(case (filter (\mark -> mark.loginId == id) marks) of 
									[] 			-> (-1,"")
									[mark:_] 	-> (mark.mark,mark.comment)
								)

writeMarksDB :: Mark -> Task [Mark]
writeMarksDB acc
=	readMarksDB
	=>> \accs -> writeDB marksId [acc:[oacc \\ oacc <- accs | oacc.loginId <> acc.loginId]] 

